Attribute VB_Name = "basDosShell"
Option Explicit
'Close window declarations
'Declare Function DestroyWindow Lib "user32" (ByVal hWnd As Long) As Long
'Declare Function CloseWindow Lib "user32" (ByVal hWnd As Long) As Long

'Send and close window api calls
Dim MhWnd As Long       'The hWnd of the window opened and closed
Declare Function PostMessage Lib "user32.dll" Alias "PostMessageA" (ByVal hWnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
'The two constants below are the message to send
'the first probalby uses proper methods (ie the ones a user would use) to close the window
'the second could just destroy the window and may leave the program running or still in memory
Public Const WM_CLOSE = &H10
'Public Const WM_DESTROY = &H2

'FindWindows declarations
Declare Function GetDesktopWindow Lib "user32.dll" () As Long
Declare Function GetWindow Lib "user32.dll" _
    (ByVal hWnd As Long, ByVal uCmd As Long) As Long
Declare Function GetWindowText Lib "user32.dll" Alias "GetWindowTextA" _
    (ByVal hWnd As Long, ByVal lpString As String, ByVal nMaxCount As Long) As Long
Declare Function GetClassName Lib "user32.dll" Alias "GetClassNameA" _
    (ByVal hWnd As Long, ByVal lpClassName As String, ByVal nMaxCount As Long) As Long
Declare Function GetParent Lib "user32.dll" (ByVal hWnd As Long) As Long
Declare Function GetWindowWord Lib "user32.dll" (ByVal hWnd As Long, _
    ByVal nIndex As Long) As Integer

Global Const GW_HWNDNEXT = 2
Global Const GW_CHILD = 5
Global Const GWW_ID = (-12)

Function FindWindowLike(hWndArray() As Long, ByVal hWndStart As _
   Long, WindowText As String, Classname As String, ID) As Integer
'FindWindowLike
' - Finds the window handles of the windows matching the specified
'   parameters
'hwndArray()
' - An integer array used to return the window handles
'hWndStart
' - The handle of the window to search under.
' - The routine searches through all of this window's children and their
'   children recursively.
' - If hWndStart = 0 then the routine searches through all windows.
'WindowText
' - The pattern used with the Like operator to compare window's text.
'ClassName
' - The pattern used with the Like operator to compare window's class
'   name.
'ID
' - A child ID number used to identify a window.
' - Can be a decimal number or a hex string.
' - Prefix hex strings with "&H" or an error will occur.
' - To ignore the ID pass the Visual Basic Null function.
'Returns
' - The number of windows that matched the parameters.
' - Also returns the window handles in hWndArray()
'----------------------------------------------------------------------

Dim LhWnd As Long
Dim sWindowText As String
Dim sClassname As String
Dim sID
Dim r As Long
' Hold the level of recursion:
Static level As Integer
' Hold the number of matching windows:
Static iFound As Integer

' Initialize if necessary:
If level = 0 Then
   iFound = 0
   ReDim hWndArray(0 To 0)
   If hWndStart = 0 Then hWndStart = GetDesktopWindow()
End If

' Increase recursion counter:
level = level + 1

' Get first child window:
LhWnd = GetWindow(hWndStart, GW_CHILD)

Do Until LhWnd = 0
   ' Search children by recursion:
   r = FindWindowLike(hWndArray(), LhWnd, WindowText, Classname, ID)

   ' Get the window text and class name:
   sWindowText = Space(255)
   r = GetWindowText(LhWnd, sWindowText, 255)
   sWindowText = Left(sWindowText, r)
   sClassname = Space(255)
   r = GetClassName(LhWnd, sClassname, 255)
   sClassname = Left(sClassname, r)

   ' If window is a child get the ID:
   If GetParent(LhWnd) <> 0 Then
      r = GetWindowWord(LhWnd, GWW_ID)
      sID = CLng("&H" & Hex(r))
   Else
      sID = Null
   End If

   ' Check that window matches the search parameters:
   If sWindowText Like WindowText Then
   'And sClassname Like Classname Then
      If IsNull(ID) Then
         ' If find a match, increment counter and add handle to array:
         iFound = iFound + 1
         ReDim Preserve hWndArray(0 To iFound)
         hWndArray(iFound) = LhWnd
      ElseIf Not IsNull(sID) Then
         If sID = CLng(ID) Then
            ' If find a match increment counter and add handle to array:
            iFound = iFound + 1
            ReDim Preserve hWndArray(0 To iFound)
            hWndArray(iFound) = LhWnd
         End If
      End If
   End If
   ' Get next child window:
   LhWnd = GetWindow(LhWnd, GW_HWNDNEXT)
Loop
' Decrement recursion counter:
level = level - 1
' Return the number of windows found:
FindWindowLike = iFound
End Function

Public Function ShellAndClose(CommandLine As String) As Boolean
On Error GoTo Err
Dim X As Long, J As Integer, Ret As Integer
'Array of hWnds
Static hWnds() As Long
'Set the function to false
ShellAndClose = False
'Shell the commandline
X = Shell(CommandLine, 2) ' Open an MS-DOS Window

'This next loop finds the window hWnd of any window
'If you use this function to shell dos programs make sure the 3rd param
'is "Finished" this way you know the Dos prog has finished

Do Until Ret = 1        'Ret is the number of windows found
    Ret = FindWindowLike(hWnds(), 0, "Finished*", "*", Null)
Loop

'If one is found set the hWnd to MhWnd so it can be closed
MhWnd = hWnds(1)
If MhWnd <> frmMain.hWnd Then 'Make sure you dont close yourself
    'Close the Window of hWnd MhWnd
    X = PostMessage(MhWnd, WM_CLOSE, 0, 0)
    'Set the function to true
    ShellAndClose = True
End If
Exit Function
Err:
'Something failed
ShellAndClose = False
Debug.Print "The Error No is : " & Err.Number
End Function

